﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# $Id: base.pyw 1809 2015-04-24 18:51:29Z Stefan $
# Copyright (C) 2015 Stefan Schwendeler ( kungpfui@rennsimulant.de )

__version__ = u'$Revision: 1809 $'
__author__ = u'Stefan Schwendeler'

import sys, os, time
import hashlib
import urllib2

info = dict(
	page    = u'rennsimulanten',
	game    = u'gtr2',
	app     = u'autoupdate',
	appver  = u'3.0',
	vendor  = u'Kungpfui',
	language= u'en'
)

raise_msg = dict(
	inet = {
		'en':'No internet connection exists or the internet connection is not allowed.\nPlease check your firewall, proxy and router settings.\n',
		'de':'Es besteht keine Internet Verbindung oder die Verbiundung ist nicht erlaubt.\nBitte überprüfe Deine Firewall, Proxy und Router Einstellungen.\n',
		},
	py_install = {
		'en':'Not supported Python version %i.%i.',
		'de':'Nicht unterstütze Python Version %i.%i.',
		},
)

def GetUrlData(url):
	"""
	Get data stream from a URL source.
	@param	url		uniform resource locator, HTTP, FTP or Gopher
	"""
	opener = urllib2.build_opener()
	opener.addheaders = [('User-agent', str('{app}/{appver}'.format(**info)))]
	data_stream = None
	retries = 5
	while retries > 0:
		try:
			url_handle = opener.open( url )
			data_stream = url_handle.read( )
			url_handle.close()
			break

		except urllib2.URLError, err_obj:
			retries -= 1
			data_stream = None
	return data_stream


def GetAppConfig(the_app, filename):
	"""
	Read configuration file
	"""
	import csv, StringIO
	cfg_data = ''
	if os.path.exists(filename):
		cfg_data = open(filename, 'rb').read()
	else:
		cfg_data = GetUrlData(the_app.source_url+filename)

	temp_config = os.path.join(the_app.myfolder, filename)
	if not cfg_data:
		if os.path.exists(temp_config):
			cfg_data = open(temp_config, 'rb').read()
		else:
			return
	else:
		temp_folder = os.path.dirname(temp_config)
		if not os.path.exists(temp_folder):
			not os.makedirs(temp_folder)
		open(temp_config, 'wb').write(cfg_data)


	config = {}
	for data in csv.reader( StringIO.StringIO(cfg_data)):
		data = [d.decode('utf-8') for d in data]
		k = len(data)
		config[data[0]] = None if k==1 else data[1] if k==2 else data[1:]
	return config


def main():
	"""
	Downloads the current version of the application and starts it.
	"""
	ver = sys.version_info[0:2]
	if ver == (2, 7):
		ver = '-'.join( ( str(info['appver']),
			'p'+'.'.join( [str(v) for v in ver]),
			'a64' if 'AMD64' in sys.version else 'i32')
			)
	else:
		Exception(raise_msg['py_install'][info['language']] % ver)


	base_url = u'https://web.{page}.de/{app}/'.format(**info)
	source_url = u'%s%s/' % (base_url, ver)

	config_filename = u'rsim_{game}.cfg'.format(**info)
	zip_filenames = (u'rsim_{game}.zip'.format(**info),)

	try:
		import wxversion
		wx_versions = '2.8-msw-unicode'
		if wxversion.checkInstalled(wx_versions, True):
			wxversion.select(wx_versions, True)
		else:
			raise Exception('Wrong wxpython version.\nInstalled Versions: ' + str(wxversion.getInstalled()) )

		# create the app
		import wx
		the_app = wx.PySimpleApp(redirect=False)
		the_app.SetClassName(u'rsim_' + info['game'])
		the_app.SetAppName(u' '.join((info['page'].capitalize(), info['app'].capitalize())))
		the_app.SetVendorName(info['vendor'])

		# set inet addresses
		the_app.base_url = base_url
		the_app.source_url = source_url
		the_app.myfolder = os.path.join(wx.StandardPaths.Get().GetUserDataDir(), info['game'])
		the_app.game = info['game']

		# get the configuration
		the_app.myconfig = GetAppConfig(the_app, config_filename)
		if not the_app.myconfig: raise Exception(raise_msg['inet'][info['language']])

		# get the zip files with the application code
		if not os.path.exists(the_app.myfolder):
			os.makedirs(the_app.myfolder)

		for archive in zip_filenames:
			archive_path = os.path.join(the_app.myfolder, archive)
			if os.path.exists(archive_path) and the_app.myconfig[archive] == hashlib.md5(open(archive_path,'rb').read()).hexdigest():
				pass
			else:
				archive_data = GetUrlData(source_url+archive)
				if archive_data: open(archive_path, 'wb').write(archive_data)
				else: raise Exception(raise_msg['inet'][info['language']])

			# add Zip file in front of the search path
			sys.path.insert(0, archive_path)

		# now call main routine
		import autoupdate
		autoupdate.main(the_app, language=info['language'])


	except ImportError, err:
		if 'wx' in str(err):
			# sometimes users don't read anything or just download the wxpython lib but don't install it. So give them some hints.
			import webbrowser
			webbrowser.open_new_tab( base_url + u'_info/missing_wxpython_{language}.html'.format(**info) )
		elif 'DLL load failed' in str(err):
			# sometimes python was not installed as Administrator, so the runtime can be missing
			import webbrowser
			webbrowser.open_new_tab( base_url + u'_info/missing_runtime_{language}.html'.format(**info) )
		else:
			raise


if __name__ == '__main__':
	log_filename = u'error.log'
	try:
		# remove old log file if it exists
		if os.path.exists(log_filename):
			os.remove(log_filename)
		main()

	except:
		sys.stderr = open(log_filename, 'w')
		raise

	finally:
		if os.path.exists(log_filename):
			sys.stderr.flush()
			time.sleep(1.0)
			os.startfile(log_filename)
